<?xml version="1.0"?>
<!DOCTYPE stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="true" method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>


<!-- Parameters for determining the movie cover art file name and average rating.
	These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="aveRating" select="'0'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="addMyListParam" select="'default'"/>
<xsl:param name="backPageURL" select="'default'"/>

<!-- 	Template for root document element.
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<xsl:template match="MOVIE">
		<!--Start  content table  --> 
			<table id="blueBorder" border="0" cellspacing="5" cellpadding="0"  >
			<tr> 
				<td id="wtback" valign="top">
					<b id="movieTitle"><xsl:call-template name="movieLongName"/><br/><br/></b>
				</td>
				<td id="wtback" valign="top"> 
					<div style="width:89;" id="greenback">
						<span id="smalltext">&nbsp;add to my list</span>
						<input type="checkbox">
							<xsl:attribute name="name"><xsl:value-of select="$addMyListParam"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="PRODUCT_ID"/></xsl:attribute>
						</input>
					</div>
					<!--<xsl:call-template name="movieArt"/>-->
					<br/>
				</td>
			</tr>
			<tr>
				<td>
					<span id="movieHeading">Genre:</span>&nbsp;
						<span id="normaltext"><!--<xsl:value-of select="GENRES/GENRES_ITEM[1]"/>--><xsl:for-each select="GENRES/GENRES_ITEM"><xsl:value-of select="."/><xsl:if test="position() &lt; last()">/</xsl:if></xsl:for-each></span>
<!--					<br/><span id="movieHeading">Producer:</span>&nbsp;<span id="normaltext"><xsl:apply-templates select="//CONTRIBUTORS" mode="movieProducer"/></span>
					<br/><span id="movieHeading">Director:</span>&nbsp;<span id="normaltext"><xsl:apply-templates select="//CONTRIBUTORS" mode="movieDirector"/></span>
					<br/><span id="movieHeading">Starring:</span>&nbsp;<span id="normaltext"><xsl:apply-templates select="//CONTRIBUTORS" mode="movieStar"/></span>-->

					<!--Start ratings -->
					<table border="0" cellspacing="0" cellpadding="0">
					<tr valign="top"> 
						<td width="63" height="50"><img src="images/seenitrateit.gif" width="62" height="51" /><br/></td>
						<td width="127" valign="top" align="left" height="50"> 
							<!--Start iguys table w=126-->
							<table width="126" border="0" cellspacing="0" cellpadding="0">
							<tr valign="top" align="left">
							<!-- 	title 	-->
							<td height="13" width="126"><img name="title0" src="images/spacer.gif" width="126" height="13" border="0" alt="" /></td>
							</tr>
							<tr valign="top" align="left">
								<!--	iguys	-->
								<td height="21" width="126"> 
									  <img name="iguy0" src="images/iguy_null.gif" width="95" height="21" border="0" usemap="#iguyMap0"/>
								</td>
							</tr>
								<!-- 	predicted rating line 	-->
							<tr align="left" valign="top">  
								<td height="6" width="126"><img name="line0" src="images/spacer.gif" vspace="0" width="95" height="6" border="0" alt=""/></td>
							</tr>
							</table><!--End iguys table w=126-->
						</td>
						<td align="right"><!-- Clear rating button -->
							&nbsp;&nbsp;<a href="javascript:clearRatings();" id="clearAllLink">clear</a>
						</td>
					</tr>
					<xsl:if test="$aveRating&gt;0">
						<tr valign="top"> 
							<td colspan="3" height="9"><span id="smalltext"><b>Average Rating:&nbsp;<xsl:value-of select="$aveRating"/></b></span></td>
						</tr>
					</xsl:if>
					<tr valign="top"> 
						<td colspan="3" height="29">							
							<span id="normaltext"><b>Haven't seen it? Want to?<br/></b></span>
							<!-- Radio buttons -->
							<xsl:call-template name="radioButtons">
								<xsl:with-param name="itemNum" select="'0'"/>
							</xsl:call-template>
						</td>
					</tr>
					</table>
					<!--End ratings table -->

				</td>
			</tr>
			<tr>
				<td align="center" colspan="2">
					<span id="normaltext"><p/>
					<a><xsl:attribute name="href"><xsl:value-of select="$backPageURL"/></xsl:attribute><img src="images/buttons_sm_previous.gif" width="124" height="30" alt="Previous Page" border="0"/></a>&nbsp;<input type="image" src="images/buttons_sm_submit.gif" width="124" height="30" alt="submit" />&nbsp;&nbsp;
					</span>
				</td>
			</tr>
			</table><!--End  white content table w=593 -->
</xsl:template>

</xsl:stylesheet>
